import java.lang.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.util.zip.*;

final public class Brushstroke extends Object
{  private double _adx[], _ady[];
   private boolean _fHook;
   private double _xAt, _yAt, _xMag, _yMag;

   static int _iCount = 0, _iSpeed = 5;
   static Hashtable _hashBrushstroke = new Hashtable();

   Brushstroke(double adx[], double ady[], boolean fHook)
   {  _adx = adx;
      _ady = ady;
      _fHook = fHook;
      _xAt = _yAt = 0;
      _xMag = _yMag = 1;
   }

   Brushstroke(Brushstroke brushstroke, double xAt, double yAt, double xMag, double yMag)
   {  _adx = brushstroke._adx;
      _ady = brushstroke._ady;
      _fHook = brushstroke._fHook;
      _xAt = brushstroke._xAt * xMag + xAt;
      _yAt = brushstroke._yAt * yMag + yAt;
      _xMag = brushstroke._xMag * xMag;
      _yMag = brushstroke._yMag * yMag;
   }

   static final Brushstroke[] get(String strName)
   {  return (Brushstroke[])_hashBrushstroke.get(strName);
   }

   static final void read(URL urlBase, String strFile) throws IOException
   {  InputStream inURL = (new URL(urlBase, strFile)).openStream();
      if (strFile.endsWith(".gz"))
      {  inURL = new GZIPInputStream(inURL);
      }

      BufferedInputStream in = new BufferedInputStream(inURL);
      StringBuffer sb = new StringBuffer();
      int iByte;
      while ((iByte = in.read()) >= 0)
      {  sb.append((char)iByte);
      }

      in.close();

      StringTokenizer stLines = new StringTokenizer(sb.toString(), "\r\n");
      while (stLines.hasMoreTokens())
      {  StringTokenizer stPoints = new StringTokenizer(stLines.nextToken(), ",");
	 String strName = stPoints.nextToken();
	 Vector vectorPoints = new Vector(),
	        vectorStrokes = new Vector();
	 try
	 {  while (stPoints.hasMoreTokens())
	    {  String strX = stPoints.nextToken();
	       boolean fHook;

	       if (strX.equals("import"))
	       {  double xAt = Double.valueOf(stPoints.nextToken()).doubleValue(),
		         yAt = Double.valueOf(stPoints.nextToken()).doubleValue(),
		         xMag = Double.valueOf(stPoints.nextToken()).doubleValue(),
		         yMag = Double.valueOf(stPoints.nextToken()).doubleValue();
		  Brushstroke aBrushstrokes[] = get(stPoints.nextToken());
		  if (aBrushstrokes != null)
		  {  for (int iStroke = 0; iStroke < aBrushstrokes.length; iStroke++)
		     {  vectorStrokes.addElement(new Brushstroke(aBrushstrokes[iStroke],
								 xAt, yAt, xMag, yMag));
		     }
		  }
	       }
	       else if ((fHook = (strX.equals("hook") || strX.equals("release")))
			|| strX.equals("end"))
	       {  int cPoints = vectorPoints.size() / 2;
		  double adx[] = new double[cPoints],
		         ady[] = new double[cPoints];
		  for (int iPoint = 0; iPoint < cPoints; iPoint++)
		  {  adx[iPoint] = ((Double)vectorPoints.elementAt(iPoint * 2)).doubleValue();
		     ady[iPoint] = ((Double)vectorPoints.elementAt(iPoint * 2 + 1)).doubleValue();
		  }

		  vectorStrokes.addElement(new Brushstroke(adx, ady, fHook));
		  vectorPoints.setSize(0);
	       }
	       else
	       {  vectorPoints.addElement(new Double(strX));
		  vectorPoints.addElement(new Double(stPoints.nextToken()));
	       }
	    }

	    int cStrokes;
	    if ((cStrokes = vectorStrokes.size()) > 0)
	    {  Brushstroke aBrushstrokes[] = new Brushstroke[cStrokes];
	       vectorStrokes.copyInto(aBrushstrokes);
	       _hashBrushstroke.put(strName, aBrushstrokes);
	    }
	 }
	 catch (Exception e)
	 {
	 }
      }
   }

   final static int speed()
   {  return _iSpeed;
   }

   final static void setSpeed(int iSpeed)
   {  _iSpeed = iSpeed;
   }

   final static private double hypot(double dX, double dY)
   {  return Math.sqrt(dX * dX + dY * dY);
   }

   final void draw(Image image, Component comp, Color color, int iImageSize, int iRadius)
   {  Graphics gImage = image.getGraphics();
      gImage.setColor(color);
      int iLastPoint = _adx.length - 1;
      Rectangle rectUpdate = null;
      int xPrev = -1, yPrev = -1;

      for (int iPoint = 0; iPoint <= iLastPoint; iPoint++)
      {  int iPointPrev = Math.max(iPoint - 1, 0),
	     iPointNext = Math.min(iPoint + 1, iLastPoint);
	 int iRadiusDiff = 0;

	 if (_fHook)
	 {  if (iPoint == iLastPoint - 1)
	    {  iRadiusDiff = iRadius - iRadius / 2;
	    }
	    else if (iPoint == iLastPoint)
	    {  iRadius /= 2;
	       iRadiusDiff = iRadius - iRadius / 8;
	    }
	 }

	 double xHalfMag = _xMag * 0.5,
	        yHalfMag = _yMag * 0.5;
	 double dXStart = ((_adx[iPointPrev] + _adx[iPoint]) * xHalfMag + _xAt) * iImageSize,
	        dYStart = ((_ady[iPointPrev] + _ady[iPoint]) * yHalfMag + _yAt) * iImageSize,
	        dDxEnd = ((_adx[iPointNext] - _adx[iPointPrev]) * xHalfMag) * iImageSize,
	        dDyEnd = ((_ady[iPointNext] - _ady[iPointPrev]) * yHalfMag) * iImageSize,
	        dDxControl = ((_adx[iPoint] - _adx[iPointPrev]) * xHalfMag) * iImageSize,
	        dDyControl = ((_ady[iPoint] - _ady[iPointPrev]) * yHalfMag) * iImageSize;
	 int iMaxRatio = (int)Math.ceil(hypot(dDxControl, dDyControl)
					+ hypot(dDxEnd - dDxControl, dDyEnd - dDyControl));

	 for (int iRatio = 0; iRatio <= iMaxRatio; iRatio++)
	 {  double dRatio = (double)iRatio / iMaxRatio;
	    int iRadiusCurrent = iRadius - (int)(iRadiusDiff * dRatio + 0.5);

	    double dRatioCont = dRatio * (1 - dRatio) * 2;
	    dRatio *= dRatio;

	    int xNew = (int)(dXStart
			     + dRatioCont * dDxControl
			     + dRatio * dDxEnd + 0.5),
	        yNew = (int)(dYStart
			     + dRatioCont * dDyControl
			     + dRatio * dDyEnd + 0.5);
	    if (xNew == xPrev
		&& yNew == yPrev)
	    {  continue;
	    }

	    Rectangle rectNew = new Rectangle(xPrev = xNew, yPrev = yNew, 1, 1);
	    rectNew.grow(iRadiusCurrent, iRadiusCurrent);
	    gImage.fillOval(rectNew.x, rectNew.y,
			    rectNew.width, rectNew.height);

	    if (rectUpdate == null)
	    {  rectUpdate = rectNew;
	    }
	    else
	    {  rectUpdate.add(rectNew);
	    }

	    if ((_iCount = (_iCount + 1) % _iSpeed) == 0)
	    {  Graphics gWindow = getClipGraphics(comp, rectUpdate);
	       gWindow.drawImage(image, 0, 0, comp);
	       gWindow.setColor(Color.black);
	       gWindow.fillOval(rectNew.x, rectNew.y,
				rectNew.width, rectNew.height);
	       gWindow.dispose();
	       rectUpdate = rectNew;

	       try
	       {  Thread.sleep(10);
	       }
	       catch (Exception e)
	       {
	       }
	    }
	 }
      }

      gImage.dispose();

      Graphics gWindow = getClipGraphics(comp, rectUpdate);
      gWindow.drawImage(image, 0, 0, comp);
      gWindow.dispose();
   }

   final static private Graphics getClipGraphics(Component comp, Rectangle rect)
   {  Graphics g = comp.getGraphics();
      g.clipRect(rect.x, rect.y, rect.width, rect.height);
      return g;
   }
}
